﻿Imports System
Imports System.IO
Imports System.Text
Public Class TcpClient
    Public m_strIpAddress As String = "127.0.0.1"
    Public m_iPortNo As Integer = 9000

    Private m_tcp As System.Net.Sockets.TcpClient
    Private m_ns As System.Net.Sockets.NetworkStream

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        Dim f As New Setup
        f.Owner = Me
        f.ShowDialog()

        TextAddress.Text = m_strIpAddress
        TextPortNo.Text = m_iPortNo.ToString()

        'Get all files under ".\xml".
        Dim files As String() = System.IO.Directory.GetFiles(".\xml", "*.xml", System.IO.SearchOption.AllDirectories)
        Dim idx As Integer
        For idx = 0 To files.Length - 1
            ComboBoxList.Items.Add(files(idx))
        Next

    End Sub

    Private Sub ComboBoxList_SelectedIndexChanged(sender As Object, e As EventArgs) Handles ComboBoxList.SelectedIndexChanged

    End Sub

    'Connect button
    Private Sub ButtonConnect_Click(sender As Object, e As EventArgs) Handles ButtonConnect.Click
        Try
            'Creat TcpClient and connect to TcpServer.
            m_tcp = New System.Net.Sockets.TcpClient(m_strIpAddress, m_iPortNo)

            'Get NetworkStream
            m_ns = m_tcp.GetStream()
            'Set 5 sec on Read/ Write timeout.
            m_ns.ReadTimeout = 5000
            m_ns.WriteTimeout = 5000
        Catch

        End Try
    End Sub

    'Disconnect button
    Private Sub ButtonDisconnect_Click(sender As Object, e As EventArgs) Handles ButtonDisconnect.Click
        Try
            m_ns.Close()
            m_tcp.Close()
        Catch

        End Try
    End Sub

    'Load button
    Private Sub ButtonLoad_Click(sender As Object, e As EventArgs) Handles ButtonLoad.Click
        ComboBoxList.Items.Clear()

        'Get all files under ".\xml".
        Dim files As String() = System.IO.Directory.GetFiles(".\xml", "*.xml", System.IO.SearchOption.AllDirectories)
        Dim idx As Integer
        For idx = 0 To files.Length - 1
            ComboBoxList.Items.Add(files(idx))
        Next

    End Sub

    'Send button
    Private Sub ButtonSend_Click(sender As Object, e As EventArgs) Handles ButtonSend.Click

        'Dim sendMsg As String = "<?xml version=" & Convert.ToChar(&H22) & "1.0" & Convert.ToChar(&H22) & " encoding=" & Convert.ToChar(&H22) & "UTF-8" & Convert.ToChar(&H22) & "?>" & "<message>" & "<command>GetDeviceInfo</command>" & "</message>"

        Try
            Dim sr As New StreamReader(ComboBoxList.SelectedItem.ToString(), Encoding.GetEncoding("Shift_JIS"))
            Dim sendMsg As String = sr.ReadToEnd()
            sr.Close()

            'Send data to TcpServer.
            'Convert strings to Byte arrays.
            Dim enc As System.Text.Encoding = System.Text.Encoding.UTF8
            Dim sendBytes As Byte() = enc.GetBytes(Convert.ToChar(&H2) & sendMsg & Convert.ToChar(&H3))
            'Send data.
            m_ns.Write(sendBytes, 0, sendBytes.Length)


            'Receive data from TcpServer.
            Dim resBytes As Byte() = New Byte(1024) {}
            Dim byCode As Byte() = New Byte(1) {}
            Dim nReceived As Integer = 0

            If m_ns.Read(byCode, 0, 1) > 0 Then
                ' Receiv STX.
                If byCode(0) = &H2 Then
                    Do
                        If m_ns.Read(byCode, 0, 1) > 0 Then
                            ' Store received data other than ETX into the buffer.
                            If byCode(0) <> &H3 Then
                                resBytes(nReceived) = byCode(0)
                                nReceived = nReceived + 1
                            End If
                        Else
                            Return
                        End If
                    Loop While byCode(0) <> &H3

                    'Convert received data to strings.
                    Dim resMsg As String = enc.GetString(resBytes, 0, CInt(resBytes.Length))
                    TextReceive.Text = resMsg
                Else
                    Return
                End If
            End If
        Catch

        End Try
    End Sub

End Class
