#include "Socket.h"
#include <ws2tcpip.h>

#pragma comment(lib, "Ws2_32.lib")
#pragma comment(lib, "winmm.lib")

// -------------------------------------------------- Internal variable
DWORD           s_dwSocketTimeout   = 10000;
unsigned long   g_lSendLength       = 65535;
unsigned char*  g_pSendBuffer       = NULL;

// -------------------------------------------------- Internal method

/**
 *  Receiving
 */
int LclRecv(
    SOCKET RecvSocket,
    int iRecvBufLen,
    PBYTE pbyRecvBuf
)
{
    if( pbyRecvBuf == NULL || iRecvBufLen < 1 )
    {
        return -1;
    }

    DWORD   dStartTime = timeGetTime( );
    int     iRetRecv,iErrCode;
    int     iRecvTotal = 0;

    do
    {
        iRetRecv = recv( RecvSocket,( char* )&pbyRecvBuf[iRecvTotal],( iRecvBufLen - iRecvTotal ),0 );
        if( iRetRecv == 0 )
        {   // Disconnection detection
            return -1;
        }
        else if( iRetRecv < 0 )
        {
            iErrCode = WSAGetLastError( );
            if( iErrCode != WSAEWOULDBLOCK )
            {
                return -1;
            }

            Sleep( 10 );
        }
        else
        {
            iRecvTotal += iRetRecv;
            if( iRecvTotal >= iRecvBufLen )
            {
                break;
            }
        }

    } while( s_dwSocketTimeout > ( timeGetTime( ) - dStartTime ) );

    return iRecvTotal;
}

/**
 *  Sending
 */
BOOL LclSend(
    SOCKET SendSocket,
    PBYTE pbySendBuf,
    int iSendBufLen,
    int* piSendLen
)
{
    if( pbySendBuf == NULL || iSendBufLen < 1 )
    {
        return FALSE;
    }

    DWORD   dStartTime = timeGetTime( );
    BOOL    bRet = FALSE;
    int     iRetSend,iErrCode;
    int     iSendTotal = 0;

    do
    {
        iRetSend = send( SendSocket,( char* )&pbySendBuf[iSendTotal],( iSendBufLen - iSendTotal ),0 );
        if(iRetSend < 1)
        {
            iErrCode = WSAGetLastError( );
            if( iErrCode != WSAEWOULDBLOCK )
            {
                break;
            }

            Sleep( 10 );
        }
        else
        {
            iSendTotal += iRetSend;
            if( iSendTotal >= iSendBufLen )
            {
                bRet = TRUE;
                break;
            }
        }

    } while( s_dwSocketTimeout > ( timeGetTime( ) - dStartTime ) );

    if( piSendLen != NULL )
    {
        *piSendLen = iSendTotal;
    }

    return bRet;
}

/**
 *  Initialize Socket
 */
void InitSocket(
)
{
    WSADATA data;
    WSAStartup( MAKEWORD(2, 0), &data );

    g_pSendBuffer = ( unsigned char* )malloc( g_lSendLength );
}

/**
 *  Release Socket
 */
void EndSocket(
)
{
    WSACleanup( );

    if( g_pSendBuffer != NULL )
    {
        free( g_pSendBuffer );
    }
    g_pSendBuffer = NULL;
}

/**
 *  Connecting
 *
 * @param   pstrIpAddress   (I)IP address
 * @param   iPortNo         (I)Port number
 * @return  Socket
 */
SOCKET ConnectSocket(
    TCHAR *pstrIpAddress,
    int iPortNo
)
{
    SOCKET Socket = socket( AF_INET, SOCK_STREAM, 0 );   
    if( Socket == INVALID_SOCKET )
    {
        return INVALID_SOCKET;
    }

    struct sockaddr_in stAddrInSend;
    stAddrInSend.sin_port = htons( iPortNo );
    stAddrInSend.sin_family = AF_INET;
    InetPton( stAddrInSend.sin_family, pstrIpAddress, &stAddrInSend.sin_addr.S_un.S_addr );

    if( connect(Socket, (struct sockaddr *)&stAddrInSend, sizeof(stAddrInSend)) == SOCKET_ERROR )
    {
        closesocket( Socket );
        return INVALID_SOCKET;
    }
    return Socket;
}

/**
 *  Disconnecting
 *
 * @param   Socket  (I)Socket
 */
void DisconnectSocket(
    SOCKET Socket
)
{
    if( Socket == INVALID_SOCKET )
    {
        return;
    }
    shutdown( Socket, SD_BOTH );

    closesocket( Socket );
}

/**
 *  Receiving
 *
 * @param   RecvSocket (I)Socket
 * @param   pbyRecvBuf (O)Buffer to store data
 * @return  Size of received data
 */
int RecvXml(
    SOCKET RecvSocket,
    PBYTE pbyRecvBuf
)
{
    BYTE byCode = 0x00;
    int nReceived = 0;

    if( LclRecv( RecvSocket, 1, &byCode ) > 0 )
    {
        // Receive STX
        if( byCode == 0x02 )
        {
            do
            {
                if( LclRecv( RecvSocket, 1, &byCode ) > 0 )
                {
                    // Store received data other than ETX into the buffer.
                    if( byCode != 0x03 )
                    {
                        pbyRecvBuf[ nReceived++ ] = byCode;
                    }
                }
                else
                {
                    return 0;
                }
            } while( byCode != 0x03 );  // Break the loop if received ETX.
        }
        else
        {
            return 0;
        }
    }
    return nReceived;
}

/**
 *  Sending
 *
 * @param   RecvSocket (I)Socket
 * @param   pbySendBuf (I)Buffer for sent data
 * @param   iSendBufLen(I)Size of sending data
 * @return  Size of sent data
 */
int SendXml(
    SOCKET SendSocket,
    PBYTE pbySendBuf,
    int iSendBufLen
)
{
	int iSendLen = 0;

	// Initialize
	memset( g_pSendBuffer, 0, g_lSendLength );

    // Set STX.
    g_pSendBuffer[0] = 0x02;
    // Copy data.
    memcpy( &g_pSendBuffer[1], pbySendBuf, iSendBufLen );
    // Set ETX.
    g_pSendBuffer[iSendBufLen + 1] = 0x03;

    // Send
    LclSend( SendSocket, g_pSendBuffer, iSendBufLen+2, &iSendLen );

    return iSendLen;
}

