#include "Socket.h"
#include "resource.h"
#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <io.h>
#include <TCHAR.h>
#include <stdlib.h>


LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT CALLBACK ConnectionDlgProc( HWND, UINT, WPARAM, LPARAM );

BOOL InitApp( HINSTANCE );
BOOL InitInstance( HINSTANCE, int );
BOOL LoadXmlList( HANDLE );
BOOL SendXmlFile( HWND );
BOOL RecvXmlFile( HWND );

// -------------------------------------------------- Internal variable
HINSTANCE       g_hInst;
LPCTSTR         szClassName         = _T("TcpClient01");    // Class name

TCHAR           g_strIpAddress[32]  = _T("127.0.0.1");      // IP address
TCHAR           g_strPortNo[32]     = _T("9000");           // Port number
SOCKET          g_sockConnect       = INVALID_SOCKET;       // Socket

unsigned long   g_lRecvLength       = 65535;                // Length of sending/receiving buffer
unsigned char*  g_pRecvBuffer       = NULL;                 // Sending/Receiving buffer


// Main

int WINAPI WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    PSTR lpCmdLine,
    int nCmdShow
)
{
    MSG msg;
    g_hInst = hInstance;

    if( !hPrevInstance )
    {
        if( !InitApp(hInstance) )
        {
            return FALSE;
        }
    }
    if( !InitInstance(hInstance, nCmdShow) )
    {
        return FALSE;
    }

    while( GetMessage(&msg, NULL, 0, 0) )
    {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }
    return ( int )msg.wParam;
}

// Register Window class

BOOL InitApp(
    HINSTANCE hInst
)
{
    WNDCLASS wc;
    wc.style = 0;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = DLGWINDOWEXTRA;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon( hInst, MAKEINTRESOURCE(IDI_ICON) );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = ( HBRUSH )( COLOR_WINDOW );
    wc.lpszMenuName = szClassName;
    wc.lpszClassName = szClassName;
    return( RegisterClass(&wc) );
}

// Create Window

BOOL InitInstance(
    HINSTANCE hInstance,
    int nCmdShow
)
{
    HWND hWnd = CreateDialog( g_hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)WndProc );
    if( hWnd == NULL )
    {
        return FALSE;
    }

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    return TRUE;
}

// Send XML

BOOL SendXmlFile(
    HWND hWnd
)
{
    int iCurSel, iLength = 0;
    TCHAR path[_MAX_PATH  + 1];
    TCHAR drive[_MAX_PATH  + 1], dir[_MAX_PATH  + 1], fname[_MAX_PATH  + 1];
    long lSize;
    fpos_t fsize;
    FILE* fp;

    // Check and initialize sending/receiving buffer
    if( g_pRecvBuffer == NULL )
    {
        return FALSE;
    }
    memset( g_pRecvBuffer, 0, g_lRecvLength );

    iCurSel = ( int )SendDlgItemMessage( hWnd, IDC_MAINDLG_LIST, CB_GETCURSEL, 0, 0 );
    if( iCurSel == LB_ERR )
    {
        return FALSE;
    }

    iLength = ( int )SendDlgItemMessage( hWnd, IDC_MAINDLG_LIST, CB_GETLBTEXT, iCurSel,(LPARAM)fname );
    if( iLength < 1 )
    {
        return FALSE;
    }

    // Get the module file path name.
    if( GetModuleFileName(NULL, path, _countof(path)) == 0 )
    {
        return FALSE;
    }

    // Split the module file path name.
    _tsplitpath_s( path, drive, _countof(drive), dir, _countof(dir), NULL, 0, NULL, 0 );
    _stprintf_s( dir, _countof(dir), _T("%sxml"), dir );
    // Make the path name to search the file name for the combo-box.
    _tmakepath_s( path, _countof(path), drive, dir, fname, NULL );

    // Get the length of the file name.
    if( _tfopen_s( &fp, path, _T("rb") ) != 0 )
    {
        return FALSE;
    }
    fseek( fp, 0, SEEK_END ); 
	fgetpos( fp, &fsize );
    lSize = ( long )fsize;

    // Load the file.
    fseek( fp, 0, SEEK_SET );
    fread( g_pRecvBuffer, sizeof(BYTE), lSize, fp );
    
    // Send XML
    if( SendXml(g_sockConnect, g_pRecvBuffer, lSize) < 0 )
    {
        fclose( fp );
        return FALSE;
    }
    fclose( fp );

    return TRUE;
}

// Receive XML

BOOL RecvXmlFile(
    HWND hWnd
)
{
    // Check and initialize sending/receiving buffer
    if( g_pRecvBuffer == NULL )
    {
        return FALSE;
    }
    memset( g_pRecvBuffer, 0, g_lRecvLength );

    // Receive XML
    if( RecvXml(g_sockConnect, g_pRecvBuffer) > 0 )
    {
        SetWindowText( GetDlgItem(hWnd, IDC_MAINDLG_RECEIVE), (LPCTSTR)g_pRecvBuffer );
    }
    return TRUE;
}

// Redraw XML list

BOOL LoadXmlList(
    HANDLE hWnd
)
{
    TCHAR path[_MAX_PATH + 1]; 
    TCHAR drive[_MAX_PATH  + 1], dir[_MAX_PATH  + 1];
    struct _tfinddata_t fdata;
    intptr_t fh;

    // Initialize
    SendDlgItemMessage( hWnd, IDC_MAINDLG_LIST, CB_RESETCONTENT, 0, 0 );

    // Get the module file path name.
    if( 0 != GetModuleFileName(NULL, path, _countof(path)) )
    {
        // Split the module file path name.
        _tsplitpath_s( path, drive, _countof(drive), dir, _countof(dir), NULL, 0, NULL, 0 );
        // Make the path name to search the file name for the combo-box.
        _tmakepath_s( path, _countof(path), drive, dir, _T("xml"), _T("\\*") );
        
        // Search the file by the path name for searching.
        fh = _tfindfirst( path, &fdata );
        if( fh == -1 )
        {
            return FALSE;
        }

        do
        {
            // Add the file name into the combo box.
            if( (fdata.attrib & _A_SUBDIR) == 0 )
            {
                SendDlgItemMessage( hWnd, IDC_MAINDLG_LIST, CB_ADDSTRING, 0, (LPARAM)fdata.name );
            }
        } while( _tfindnext(fh, &fdata) == 0 );
        _findclose( fh );

        // Select the head of the combo box.
        SendDlgItemMessage( hWnd, IDC_MAINDLG_LIST, CB_SETCURSEL, 0, 0 );
    }
    return TRUE;
}

// Window procedure

LRESULT CALLBACK WndProc(
    HWND hWnd,
    UINT msg,
    WPARAM wp,
    LPARAM lp
)
{
    switch( msg )
    {
        case WM_INITDIALOG:
            g_pRecvBuffer = ( unsigned char* )malloc( g_lRecvLength );

            InitSocket( );
            LoadXmlList( hWnd );
            EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_CONNECT), TRUE );
            EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_DISCONNECT), FALSE );
            return FALSE;
        case WM_CREATE:
            if( g_sockConnect != INVALID_SOCKET )
            {
                DisconnectSocket( g_sockConnect );
                g_sockConnect = INVALID_SOCKET;
            }
            EndSocket( );
   		    PostMessage( hWnd, WM_COMMAND, IDD_CONNECTIONDLG, 0 );
		    return TRUE;
        case WM_DESTROY:
            free( g_pRecvBuffer );

            PostQuitMessage( 0 );
            break;
        case WM_COMMAND:
            switch( LOWORD(wp) )
            {
                case IDD_CONNECTIONDLG:
                    if( DialogBox(g_hInst, MAKEINTRESOURCE(IDD_CONNECTIONDLG), hWnd, (DLGPROC)ConnectionDlgProc) != TRUE )
                    {
                        PostQuitMessage( 0 );
                    }
                    // Set IP address
                    SetWindowText( GetDlgItem(hWnd, IDC_MAINDLG_ADDRESS), g_strIpAddress );
                    // Set Port number
                    SetWindowText( GetDlgItem(hWnd, IDC_MAINDLG_PORTNO), g_strPortNo );
                    break;
                case IDC_MAINDLG_CONNECT:       // Connect
                    if( g_sockConnect == INVALID_SOCKET )
                    {
                        g_sockConnect = ConnectSocket( g_strIpAddress, _ttoi(g_strPortNo) );
                        if( g_sockConnect == INVALID_SOCKET )
                        {
                            // error
                        }
                    }
                    else
                    {
                        // error
                    }
                    EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_CONNECT), FALSE );
                    EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_DISCONNECT), TRUE );
                    return TRUE;
                case IDC_MAINDLG_DISCONNECT:    // Disconnect
                    if( g_sockConnect != INVALID_SOCKET )
                    {
                        DisconnectSocket( g_sockConnect );
                        g_sockConnect = INVALID_SOCKET;
                    }
                    else
                    {
                        // error
                    }
                    EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_CONNECT), TRUE );
                    EnableWindow( GetDlgItem(hWnd, IDC_MAINDLG_DISCONNECT), FALSE );
                    return TRUE;
                case IDC_MAINDLG_RELOAD:        // Reload
                    LoadXmlList( hWnd );
                    return FALSE;
                case IDC_MAINDLG_SEND:          // Send
                    if( SendXmlFile( hWnd ) )
                    {
                        RecvXmlFile( hWnd );
                    }
                    return TRUE;
            }
            break;
        default:
            return( DefWindowProc(hWnd, msg, wp, lp) );
    }
    return 0;
}

// Window procedure

LRESULT CALLBACK ConnectionDlgProc(
    HWND hWnd,
    UINT msg,
    WPARAM wp,
    LPARAM lp
)
{
    switch( msg )
    {
        case WM_INITDIALOG:
            // Set IP address
            SetWindowText( GetDlgItem(hWnd, IDC_SETCONNECTIONDLG_ADDRESS), g_strIpAddress );
            // Set Port number
            SetWindowText( GetDlgItem(hWnd, IDC_SETCONNECTIONDLG_PORTNO), g_strPortNo );
            break;
        case WM_COMMAND:
            switch( LOWORD(wp) )
            {
                case IDOK:
                    // Get IP address
                    GetWindowText( GetDlgItem(hWnd, IDC_SETCONNECTIONDLG_ADDRESS), g_strIpAddress, _countof(g_strIpAddress) );
                    // Get Port number
                    GetWindowText( GetDlgItem(hWnd, IDC_SETCONNECTIONDLG_PORTNO), g_strPortNo, _countof(g_strPortNo) );
                    EndDialog( hWnd, TRUE );
                    return TRUE;
                case IDCANCEL:
			        EndDialog( hWnd, FALSE );
                    return TRUE;
                default:
                    break;
            }
            return FALSE;
    }
    return FALSE;
}
